/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.events;

import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.configs.BroadcastSettings;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class SpawnEventListener {
    public static void onPokemonSpawn(SpawnEvent<PokemonEntity> event) {
        boolean shouldBroadcastShiny;
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        boolean isBroadcastEnabled = config.isBroadcastEnabled;
        if (!isBroadcastEnabled) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)event.getEntity();
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.isPlayerOwned()) {
            return;
        }
        boolean isLegendary = pokemon.isLegendary();
        boolean isMythical = pokemon.isMythical();
        boolean isUltraBeast = pokemon.isUltraBeast();
        boolean isShiny = pokemon.getShiny();
        boolean bl = shouldBroadcastShiny = SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny") && isShiny;
        if (!(isLegendary || isMythical || isUltraBeast || shouldBroadcastShiny)) {
            return;
        }
        SpawningContext ctx = event.getCtx();
        Spawner spawner = ctx.getSpawner();
        class_3222 player = null;
        MinecraftServer server = null;
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            player = MythsAndLegendsConditions.getPlayerFromUUID(ctx.getWorld(), playerSpawner.getUuid());
            if (player != null) {
                server = player.method_5682();
            }
        }
        class_5250 PokemonDisplayName = pokemon.getDisplayName();
        class_2338 pos = pokemonEntity.method_24515();
        class_5250 message = class_2561.method_43469((String)"chat.broadcast.spawn", (Object[])new Object[]{PokemonDisplayName});
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Location")) {
            message.method_10852((class_2561)class_2561.method_43469((String)"chat.broadcast.location", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27692(class_124.field_1060));
        }
        if (pokemon.isLegendary() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Legendarys")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.broadcast.legendary").method_27692(class_124.field_1065));
        }
        if (pokemon.isMythical() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Mythicals")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.broadcast.mythical").method_27692(class_124.field_1064));
        }
        if (pokemon.isUltraBeast() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "UltraBeasts")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.broadcast.ultrabeast").method_27692(class_124.field_1062));
        }
        if (pokemon.getShiny() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny")) {
            message.method_10852((class_2561)class_2561.method_43471((String)"chat.broadcast.shiny").method_27692(class_124.field_1076));
        }
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Level")) {
            int level = pokemon.getLevel();
            message.method_10852((class_2561)class_2561.method_43469((String)"chat.broadcast.level", (Object[])new Object[]{level}).method_27692(class_124.field_1054));
        }
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "BroadcastToAll")) {
            if (server != null) {
                SpawnEventListener.broadcastMessageToServer((class_2561)message, server);
            }
        } else if (player != null) {
            player.method_43496((class_2561)message);
        }
    }

    private static boolean findBroadcastConfig(List<BroadcastSettings> settings, String settingName) {
        for (BroadcastSettings setting : settings) {
            if (!setting.settingName.equalsIgnoreCase(settingName)) continue;
            return setting.settingValue;
        }
        return false;
    }

    private static void broadcastMessageToServer(class_2561 message, MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(message, false);
        }
    }
}

